import com.liferay.asset.kernel.service.AssetTagLocalServiceUtil
import com.liferay.asset.kernel.model.AssetTag
import com.liferay.asset.kernel.service.AssetEntryLocalServiceUtil
import com.liferay.asset.kernel.model.AssetEntry
import java.util.List

def wwwgroupId = 112015
def hubgroupId = 127828

def wwwstagingGrpId = 236376
def hubstagingGrpId = 381376

def currentLiveId = hubgroupId
def currentStagingId = hubstagingGrpId

out.println("Change the groupId accordingly")
List<AssetTag>  list = AssetTagLocalServiceUtil.getGroupTags(currentLiveId)
int srno = 1
for(AssetTag t: list) {
	String name = t.getName();
	long id = t.getTagId();
	
	if(name.indexOf("(duplicate)") != -1) {
		int count = AssetEntryLocalServiceUtil.getAssetTagAssetEntriesCount(id);
		if(count == 0) {
			out.println("Deleting Tag name  = " + t.getName() + "as count is " + count)
			AssetTagLocalServiceUtil.deleteTag(id)
			out.println("Successfully Deleted tag")
		} else {
			List<AssetEntry> alist = AssetEntryLocalServiceUtil.getAssetTagAssetEntries(id)
			for(AssetEntry ae : alist) {
				AssetEntry stagedAE = AssetEntryLocalServiceUtil.fetchEntry(currentStagingId, ae.getClassUuid())
				
				List<AssetTag> atList = ae.getTags();
				
				out.println(srno+". LIVE asset entry is " + ae.getClassUuid() +"-- " + ae.getTitle() )
				for(AssetTag at : atList){
					out.print(at.getTagId() + " : " + at.getName() +",")
				}
				if(stagedAE != null) {
					List<AssetTag> stagedAtList = stagedAE.getTags();
					long[] liveMappingTagIds = AssetTagLocalServiceUtil.getTagIds(currentLiveId, stagedAE.getTagNames())	
					out.println("Live Mapping TagIds are : " +liveMappingTagIds);
					AssetTagLocalServiceUtil.clearAssetEntryAssetTags(ae.getEntryId())
					AssetTagLocalServiceUtil.addAssetEntryAssetTags(ae.getEntryId(),liveMappingTagIds)
					out.println("Updated tags with : " + ae.getTagNames())
					
					}
				else {
					out.println("Not staged asset entry found")
				}
				srno++;
			}
		}
	}
	
}

